//setenv LD_LIBRARY_PATH /home/jacek/kylix3/bin
//Zmienic "/" na PathDelim

//---------------------------------------------------------------------------

#include <clx.h>
#pragma hdrstop

#include "fMain.h"
#include "fProgressForm.h"
#include "fInputDialog.h"
#include "fAbout.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.xfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
//w View as Text: Directory.Location='/'
FileListView1->Directory->Location=".";
FileListView2->Directory->Location=".";
FileListView1Enter(FileListView1);
FormResize(this);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FileListView1Enter(TObject *Sender)
{
TFileListView* FLVSender=(TFileListView*)Sender;
SourceFileList=FLVSender;
TargetFileList=(FLVSender==FileListView1)?FileListView2:FileListView1;
FLVSender->Color=clBase;
this->Caption="XCommander "+FLVSender->Directory->Location;

TargetFileList->Color=clButton;
//TargetFileList->Selected=NULL;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FileListView1Exit(TObject *Sender)
{
/*
TFileListView* FLVSender=(TFileListView*)Sender;
FLVSender->Color=clButton;
FLVSender->Selected=NULL;
*/
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FileListView1Change(TObject *Sender,
      TListItem *Item, TItemChange Change)
{
TFileListView* FLVSender=(TFileListView*)Sender;
this->Caption="XCommander "+FLVSender->Directory->Location;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
//if ((Key==Key_F1) && Shift.Contains(ssCtrl)) FileListView1->Directory->Location="";
//if ((Key==Key_F2) && Shift.Contains(ssCtrl)) FileListView2->Directory->Location="";
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button5Click(TObject *Sender)
{
if (NN_Requirecopyconfirmation1->Checked) if (Application->MessageBox("Are you sure to copy selected file(s) to "+TargetFileList->Directory->Location+"?",MessageCaption,TMessageButtons() << smbYes << smbNo,smsInformation,smbNo,smbNo)==smbNo) return;
KopiujPrzeniesZaznaczone(2);
FileListsRefresh();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button9Click(TObject *Sender)
{
if (NN_Requireexitconfirmation1->Checked) if (Application->MessageBox("Are you sure you want to leave me?",MessageCaption,TMessageButtons() << smbYes << smbNo,smsInformation,smbNo,smbNo)==smbNo) return;
Close();
}
//---------------------------------------------------------------------------


void __fastcall TForm1::Button7Click(TObject *Sender)
{
//InputDialog->Text="New Folder";
InputDialog->Text="";
InputDialog->Execute();
AnsiString katalog=InputDialog->Text;
if (katalog.IsEmpty()) return;
if (katalog.Pos(PathDelim)==0)
        katalog=(AnsiString)SourceFileList->Directory->Location+katalog;
        else
        katalog=ExpandFileName(katalog);

if (CreateDir(katalog))
        //ShowMessage("Directory created: "+katalog);
        ;
        else
        ShowMessage("Directory creation failed! ("+katalog+")");

FileListsRefresh();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button8Click(TObject *Sender)
{
if (NN_Requireremoveconfirmation1->Checked) if (Application->MessageBox("Are you sure to delete selected file(s) to "+TargetFileList->Directory->Location+"?",MessageCaption,TMessageButtons() << smbYes << smbNo,smsInformation,smbNo,smbNo)==smbNo) return;
KasujZaznaczone(false);
FileListsRefresh();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FileListsRefresh()
{
FileListView1->Refresh();
FileListView2->Refresh();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button6Click(TObject *Sender)
{
if (NN_Requireremoveconfirmation1->Checked) if (Application->MessageBox("Are you sure to move selected file(s) to "+TargetFileList->Directory->Location+"?",MessageCaption,TMessageButtons() << smbYes << smbNo,smsInformation,smbNo,smbNo)==smbNo) return;
KopiujPrzeniesZaznaczone(3);
KasujZaznaczone(true);
FileListsRefresh();
}
//---------------------------------------------------------------------------

TList* __fastcall TForm1::StworzListePlikow()
{
TList* lista=new TList();
for(int i=0;i<SourceFileList->SelCount;i++)
        {
        bool czy_katalog=(SourceFileList->Selections[i]->SR.Attr & faDirectory)==faDirectory;
        AnsiString nazwa_pliku_katalogu=(AnsiString)SourceFileList->Directory->Location+SourceFileList->Selections[i]->SR.Name;
        if (nazwa_pliku_katalogu!="..")
                {
                if (czy_katalog)
                        dodaj_do_listy_pliki_z_katalogu(nazwa_pliku_katalogu,lista,true,true);
                        else
                        dodaj_do_listy_plik(nazwa_pliku_katalogu,lista);
                }
        }

lista->Sort(porownaj_opisy_plikow);
return lista;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::UsunListePlikow(TList* lista)
{
//Usuwanie rekordow
for(int indeks=0;indeks<lista->Count;indeks++) delete lista->Items[indeks];
lista->Clear();
delete lista;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::TestListyPlikow(TList* lista,bool zostaw)
{
TListBox* ListBox=new TListBox(this);
ListBox->Width=ClientWidth;
ListBox->Height=ClientHeight;
ListBox->Parent=this;
for(int indeks=0;indeks<lista->Count;indeks++)
        {
        opis_pliku* rekord=(opis_pliku*)(lista->Items[indeks]);
        AnsiString source_file=rekord->nazwa_pliku;
        ListBox->Items->Add(rekord->nazwa_pliku+", "+(rekord->czy_katalog?"katalog":"plik")+", "+rekord->poziom);
        }
if (zostaw)
        {
        ShowMessage("Schowaj liste");
        delete ListBox;
        }
}

//---------------------------------------------------------------------------

void __fastcall TForm1::KasujZaznaczone(bool tylko_katalogi)
{
TList* lista=StworzListePlikow();

//TestListyPlikow(lista,false);return;

ProgressForm->OperationLabel->Caption="Kasowanie";
ProgressForm->ProgressBar1->Min=0;
ProgressForm->ProgressBar1->Max=lista->Count-1;
ProgressForm->Show();

for(int indeks=lista->Count-1;indeks>=0;indeks--)
        {
        opis_pliku* rekord=(opis_pliku*)(lista->Items[indeks]);
        AnsiString nazwa_pliku_katalogu=rekord->nazwa_pliku;
        ProgressForm->SourceLabel->Caption=nazwa_pliku_katalogu;
        ProgressForm->TargetLabel->Caption="";
        ProgressForm->ProgressBar1->Position=indeks;
        if (rekord->czy_katalog)
                KasujPustyKatalog(nazwa_pliku_katalogu);
                else
                if (!tylko_katalogi) KasujPlik(nazwa_pliku_katalogu);
        //ShowMessage("OK");
        }

ProgressForm->Hide();

UsunListePlikow(lista);
};
//---------------------------------------------------------------------------

void __fastcall TForm1::KopiujPrzeniesZaznaczone(int operacja)
{
/*
operacja:
0 - nic
2 - kopiuj
3 - przenies
*/

TList* lista=StworzListePlikow();
switch(operacja)
        {
        case 0: ProgressForm->OperationLabel->Caption="none"; break;
        case 2: ProgressForm->OperationLabel->Caption="Copy"; break;
        case 3: ProgressForm->OperationLabel->Caption="Move/Rename"; break;
        };
ProgressForm->ProgressBar1->Min=0;
ProgressForm->ProgressBar1->Max=lista->Count-1;
ProgressForm->Show();

AnsiString base_dir_path=""; //pelna sciezka
AnsiString base_dir_name=""; //tylko nazwa katalogu
AnsiString source_file="";
AnsiString target_file="";

AnsiString katalog_docelowy=(AnsiString)TargetFileList->Directory->Location;

//Dla plikow
for(int indeks=0;indeks<lista->Count;indeks++)
        {
        opis_pliku* rekord=(opis_pliku*)(lista->Items[indeks]);

        if (rekord->poziom==0 && rekord->czy_katalog) //Przygotowanie wzglednej sciezki dla plikow wewnatrz katalogow
                {
                base_dir_path=rekord->nazwa_pliku+"/";
                base_dir_name=ExtractRelativePath((AnsiString)SourceFileList->Directory->Location,base_dir_path);
                }
        if (rekord->poziom==0 && !rekord->czy_katalog) //Dla plikow na poziomie 0
                {
                base_dir_path=(AnsiString)SourceFileList->Directory->Location;
                base_dir_name="";
                }

        source_file=rekord->nazwa_pliku;
        ProgressForm->SourceLabel->Caption=source_file;
        if (rekord->nazwa_pliku+"/"==base_dir_path) //pierwszy element
                target_file=katalog_docelowy+base_dir_name;
                else
                target_file=katalog_docelowy+base_dir_name+ExtractRelativePath(base_dir_path,rekord->nazwa_pliku);
        ProgressForm->TargetLabel->Caption=target_file;
        ProgressForm->ProgressBar1->Position=indeks;


        switch(operacja)
                {
                case 0: break;
                case 2: if (rekord->czy_katalog) CreateDir(target_file); else KopiujPlik(source_file,target_file); break;
                case 3: if (rekord->czy_katalog) CreateDir(target_file); else PrzeniesPlik(source_file,target_file); break;
                };

        //ShowMessage((AnsiString)":"+rekord->poziom+": OK");
        }

ProgressForm->Hide();

UsunListePlikow(lista);
};
//---------------------------------------------------------------------------



void __fastcall TForm1::MM_List1Click(TObject *Sender)
{
MM_List1->Checked=true;
MM_Report1->Checked=false;
SourceFileList->ViewStyle=vsList;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MM_Report1Click(TObject *Sender)
{
MM_List1->Checked=false;
MM_Report1->Checked=true;
SourceFileList->ViewStyle=vsReport;
}
//---------------------------------------------------------------------------


void __fastcall TForm1::MM_Rootdirectory1Click(TObject *Sender)
{
FileListView1->Directory->Location="";
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MM_Rootdirectoryright1Click(TObject *Sender)
{
FileListView2->Directory->Location="";
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MM_Homedirectory1Click(TObject *Sender)
{
FileListView1->Directory->Location="~";        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MM_Homedirectoryright1Click(TObject *Sender)
{
FileListView2->Directory->Location="~";
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MM_Changeactivepanel1Click(TObject *Sender)
{
TargetFileList->SetFocus();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MM_Switchpanels1Click(TObject *Sender)
{
WideString tmp_DirectoryLocation=TargetFileList->Directory->Location;
TargetFileList->Directory->Location=SourceFileList->Directory->Location;
SourceFileList->Directory->Location=tmp_DirectoryLocation;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button2Click(TObject *Sender)
{
ProgramExecute("xterm","-n","XCommander-XTerm");
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button3Click(TObject *Sender)
{
AnsiString nazwapliku=(AnsiString)(SourceFileList->Directory->Location+SourceFileList->ItemFocused->Caption);
//ShowMessage(nazwapliku);

//Sprawdzam czy katalog
if (!IsDirectory(nazwapliku)) ProgramExecute("XEdit","-view",nazwapliku);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button4Click(TObject *Sender)
{
AnsiString nazwapliku=(AnsiString)(SourceFileList->Directory->Location+SourceFileList->ItemFocused->Caption);
//ShowMessage(nazwapliku);

//Sprawdzam czy katalog
if (!IsDirectory(nazwapliku)) ProgramExecute("XEdit",nazwapliku,NULL);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Editnewfile1Click(TObject *Sender)
{
ProgramExecute("XEdit",NULL,NULL);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::NN_Requireexitconfirmation1Click(TObject *Sender)
{
((TMenuItem*)Sender)->Checked=!((TMenuItem*)Sender)->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormResize(TObject *Sender)
{
int szer=(ClientWidth-Splitter1->Width)/2;
FileListView1->Width=szer;

int wys=Panel1->ClientHeight;
Button1->Height=wys;
Button2->Height=wys;
Button3->Height=wys;
Button4->Height=wys;
Button5->Height=wys;
Button6->Height=wys;
Button7->Height=wys;
Button8->Height=wys;
Button9->Height=wys;
szer=ClientWidth/9;
Button1->Width=szer;
Button2->Width=szer;
Button3->Width=szer;
Button4->Width=szer;
Button5->Width=szer;
Button6->Width=szer;
Button7->Width=szer;
Button8->Width=szer;
Button9->Width=szer;
Button1->Left=2;
Button2->Left=Button1->Left+Button1->Width;
Button3->Left=Button2->Left+Button2->Width;
Button4->Left=Button3->Left+Button3->Width;
Button5->Left=Button4->Left+Button4->Width;
Button6->Left=Button5->Left+Button5->Width;
Button7->Left=Button6->Left+Button6->Width;
Button8->Left=Button7->Left+Button7->Width;
Button9->Left=Button8->Left+Button8->Width;
}
//---------------------------------------------------------------------------




void __fastcall TForm1::MM_Selectall1Click(TObject *Sender)
{
SourceFileList->InvertSelection();
}
//---------------------------------------------------------------------------


//DRAG'N'DROP
void __fastcall TForm1::FileListView1MouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
//Rozpoczecie przenoszenia
if (Button == mbLeft) ((TFileListView*)Sender)->BeginDrag(false);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FileListView2DragOver(TObject *Sender,
      TObject *Source, int X, int Y, TDragState State, bool &Accept)
{
//Akceptacja przenoszonego elementu
Accept=false;
if (Source!=Sender) Accept=true;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FileListView2DragDrop(TObject *Sender,
      TObject *Source, int X, int Y)
{
Button6Click(Sender);
}
//---------------------------------------------------------------------------



void __fastcall TForm1::About1Click(TObject *Sender)
{
Form2->ShowModal();
}
//---------------------------------------------------------------------------


